/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public class SHA5
extends MessageDigestSpi
implements Cloneable {
    private static final int LENGTH = 64;
    private static final long[] INITIAL_HASHES = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final int ITERATION = 80;
    private static final long[] ROUND_CONSTS = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private final long COUNT_MASK = 127L;
    private long[] W = new long[80];
    private long count = 0L;
    private long AA;
    private long BB;
    private long CC;
    private long DD;
    private long EE;
    private long FF;
    private long GG;
    private long HH;

    protected int engineGetDigestLength() {
        return 64;
    }

    public SHA5() {
        this.init();
    }

    private void computeBlock() {
        int n2;
        for (n2 = 16; n2 < 80; ++n2) {
            this.W[n2] = SHA5.lf_delta1(this.W[n2 - 2]) + this.W[n2 - 7] + SHA5.lf_delta0(this.W[n2 - 15]) + this.W[n2 - 16];
        }
        long l2 = this.AA;
        long l3 = this.BB;
        long l4 = this.CC;
        long l5 = this.DD;
        long l6 = this.EE;
        long l7 = this.FF;
        long l8 = this.GG;
        long l9 = this.HH;
        for (n2 = 0; n2 < 80; ++n2) {
            long l10 = l9 + SHA5.lf_sigma1(l6) + SHA5.lf_ch(l6, l7, l8) + ROUND_CONSTS[n2] + this.W[n2];
            long l11 = SHA5.lf_sigma0(l2) + SHA5.lf_maj(l2, l3, l4);
            l9 = l8;
            l8 = l7;
            l7 = l6;
            l6 = l5 + l10;
            l5 = l4;
            l4 = l3;
            l3 = l2;
            l2 = l10 + l11;
        }
        this.AA += l2;
        this.BB += l3;
        this.CC += l4;
        this.DD += l5;
        this.EE += l6;
        this.FF += l7;
        this.GG += l8;
        this.HH += l9;
    }

    protected void engineReset() {
        this.init();
    }

    void init() {
        this.setInitialHash(INITIAL_HASHES);
        for (int i2 = 0; i2 < 80; ++i2) {
            this.W[i2] = 0L;
        }
        this.count = 0L;
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[64];
        try {
            int n2 = this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw new InternalError("");
        }
        return byArray;
    }

    protected void engineUpdate(byte by) {
        this.update(by);
    }

    private void update(int n2) {
        int n3 = (int)(this.count & 0x7FL) >>> 3;
        int n4 = (int)((this.count ^ 0xFFFFFFFFFFFFFFFFL) & 7L) << 3;
        this.W[n3] = this.W[n3] & (255L << n4 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)n2 & 0xFFL) << n4;
        ++this.count;
        if ((this.count & 0x7FL) == 0L) {
            this.computeBlock();
        }
    }

    private static long lf_delta0(long l2) {
        return SHA5.lf_S(l2, 1) ^ SHA5.lf_S(l2, 8) ^ SHA5.lf_R(l2, 7);
    }

    private static long lf_delta1(long l2) {
        return SHA5.lf_S(l2, 19) ^ SHA5.lf_S(l2, 61) ^ SHA5.lf_R(l2, 6);
    }

    private static long lf_sigma0(long l2) {
        return SHA5.lf_S(l2, 28) ^ SHA5.lf_S(l2, 34) ^ SHA5.lf_S(l2, 39);
    }

    private static long lf_sigma1(long l2) {
        return SHA5.lf_S(l2, 14) ^ SHA5.lf_S(l2, 18) ^ SHA5.lf_S(l2, 41);
    }

    private static long lf_R(long l2, int n2) {
        return l2 >>> n2;
    }

    private static long lf_S(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    private static long lf_ch(long l2, long l3, long l4) {
        return l2 & l3 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
    }

    private static long lf_maj(long l2, long l3, long l4) {
        return l2 & l3 ^ l2 & l4 ^ l3 & l4;
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < 64) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n2 < 64) {
            throw new DigestException("output buffer too small to store the digest");
        }
        this.performDigest(byArray, n2, 64);
        return 64;
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        while (n3 > 0 && (this.count & 7L) != 0L) {
            this.engineUpdate(byArray[n2]);
            ++n2;
            --n3;
        }
        while (n3 >= 8) {
            int n4 = (int)(this.count & 0x7FL) >> 3;
            this.W[n4] = ((long)byArray[n2] & 0xFFL) << 56 | ((long)byArray[n2 + 1] & 0xFFL) << 48 | ((long)byArray[n2 + 2] & 0xFFL) << 40 | ((long)byArray[n2 + 3] & 0xFFL) << 32 | ((long)byArray[n2 + 4] & 0xFFL) << 24 | ((long)byArray[n2 + 5] & 0xFFL) << 16 | ((long)byArray[n2 + 6] & 0xFFL) << 8 | (long)byArray[n2 + 7] & 0xFFL;
            this.count += 8L;
            if ((this.count & 0x7FL) == 0L) {
                this.computeBlock();
            }
            n3 -= 8;
            n2 += 8;
        }
        while (n3 > 0) {
            this.engineUpdate(byArray[n2++]);
            --n3;
        }
    }

    void performDigest(byte[] byArray, int n2, int n3) throws DigestException {
        long l2 = this.count << 3;
        this.update(128);
        while ((int)(this.count & 0x7FL) != 112) {
            this.update(0);
        }
        this.W[14] = 0L;
        this.W[15] = l2;
        this.count += 16L;
        this.computeBlock();
        switch (n3) {
            case 64: {
                byArray[n2 + 63] = (byte)(this.HH >>> 0);
                byArray[n2 + 62] = (byte)(this.HH >>> 8);
                byArray[n2 + 61] = (byte)(this.HH >>> 16);
                byArray[n2 + 60] = (byte)(this.HH >>> 24);
                byArray[n2 + 59] = (byte)(this.HH >>> 32);
                byArray[n2 + 58] = (byte)(this.HH >>> 40);
                byArray[n2 + 57] = (byte)(this.HH >>> 48);
                byArray[n2 + 56] = (byte)(this.HH >>> 56);
                byArray[n2 + 55] = (byte)(this.GG >>> 0);
                byArray[n2 + 54] = (byte)(this.GG >>> 8);
                byArray[n2 + 53] = (byte)(this.GG >>> 16);
                byArray[n2 + 52] = (byte)(this.GG >>> 24);
                byArray[n2 + 51] = (byte)(this.GG >>> 32);
                byArray[n2 + 50] = (byte)(this.GG >>> 40);
                byArray[n2 + 49] = (byte)(this.GG >>> 48);
                byArray[n2 + 48] = (byte)(this.GG >>> 56);
            }
            case 48: {
                byArray[n2 + 47] = (byte)(this.FF >>> 0);
                byArray[n2 + 46] = (byte)(this.FF >>> 8);
                byArray[n2 + 45] = (byte)(this.FF >>> 16);
                byArray[n2 + 44] = (byte)(this.FF >>> 24);
                byArray[n2 + 43] = (byte)(this.FF >>> 32);
                byArray[n2 + 42] = (byte)(this.FF >>> 40);
                byArray[n2 + 41] = (byte)(this.FF >>> 48);
                byArray[n2 + 40] = (byte)(this.FF >>> 56);
                byArray[n2 + 39] = (byte)(this.EE >>> 0);
                byArray[n2 + 38] = (byte)(this.EE >>> 8);
                byArray[n2 + 37] = (byte)(this.EE >>> 16);
                byArray[n2 + 36] = (byte)(this.EE >>> 24);
                byArray[n2 + 35] = (byte)(this.EE >>> 32);
                byArray[n2 + 34] = (byte)(this.EE >>> 40);
                byArray[n2 + 33] = (byte)(this.EE >>> 48);
                byArray[n2 + 32] = (byte)(this.EE >>> 56);
                byArray[n2 + 31] = (byte)(this.DD >>> 0);
                byArray[n2 + 30] = (byte)(this.DD >>> 8);
                byArray[n2 + 29] = (byte)(this.DD >>> 16);
                byArray[n2 + 28] = (byte)(this.DD >>> 24);
                byArray[n2 + 27] = (byte)(this.DD >>> 32);
                byArray[n2 + 26] = (byte)(this.DD >>> 40);
                byArray[n2 + 25] = (byte)(this.DD >>> 48);
                byArray[n2 + 24] = (byte)(this.DD >>> 56);
                byArray[n2 + 23] = (byte)(this.CC >>> 0);
                byArray[n2 + 22] = (byte)(this.CC >>> 8);
                byArray[n2 + 21] = (byte)(this.CC >>> 16);
                byArray[n2 + 20] = (byte)(this.CC >>> 24);
                byArray[n2 + 19] = (byte)(this.CC >>> 32);
                byArray[n2 + 18] = (byte)(this.CC >>> 40);
                byArray[n2 + 17] = (byte)(this.CC >>> 48);
                byArray[n2 + 16] = (byte)(this.CC >>> 56);
                byArray[n2 + 15] = (byte)(this.BB >>> 0);
                byArray[n2 + 14] = (byte)(this.BB >>> 8);
                byArray[n2 + 13] = (byte)(this.BB >>> 16);
                byArray[n2 + 12] = (byte)(this.BB >>> 24);
                byArray[n2 + 11] = (byte)(this.BB >>> 32);
                byArray[n2 + 10] = (byte)(this.BB >>> 40);
                byArray[n2 + 9] = (byte)(this.BB >>> 48);
                byArray[n2 + 8] = (byte)(this.BB >>> 56);
                byArray[n2 + 7] = (byte)(this.AA >>> 0);
                byArray[n2 + 6] = (byte)(this.AA >>> 8);
                byArray[n2 + 5] = (byte)(this.AA >>> 16);
                byArray[n2 + 4] = (byte)(this.AA >>> 24);
                byArray[n2 + 3] = (byte)(this.AA >>> 32);
                byArray[n2 + 2] = (byte)(this.AA >>> 40);
                byArray[n2 + 1] = (byte)(this.AA >>> 48);
                byArray[n2 + 0] = (byte)(this.AA >>> 56);
                break;
            }
            default: {
                throw new DigestException("Unsupported Digest Length!");
            }
        }
        this.engineReset();
    }

    void setInitialHash(long[] lArray) {
        this.AA = lArray[0];
        this.BB = lArray[1];
        this.CC = lArray[2];
        this.DD = lArray[3];
        this.EE = lArray[4];
        this.FF = lArray[5];
        this.GG = lArray[6];
        this.HH = lArray[7];
    }

    public Object clone() {
        SHA5 sHA5 = null;
        sHA5 = new SHA5(this);
        return sHA5;
    }

    SHA5(SHA5 sHA5) {
        this();
        System.arraycopy(sHA5.W, 0, this.W, 0, this.W.length);
        this.count = sHA5.count;
        this.AA = sHA5.AA;
        this.BB = sHA5.BB;
        this.CC = sHA5.CC;
        this.DD = sHA5.DD;
        this.EE = sHA5.EE;
        this.FF = sHA5.FF;
        this.GG = sHA5.GG;
        this.HH = sHA5.HH;
    }
}

